<?php
header("Content-Type: application/json");
include __DIR__ . "/../../../includes/config.php"; // DB connection

// Check if image file is provided
if(isset($_FILES['image'])) {

    $image = $_FILES['image'];

    // Allowed extensions
    $allowed_ext = ['jpg','jpeg','png','gif'];
    $ext = strtolower(pathinfo($image['name'], PATHINFO_EXTENSION));

    if(!in_array($ext, $allowed_ext)){
        echo json_encode([
            "status" => "error",
            "message" => "Invalid file type"
        ]);
        exit;
    }

    // Create unique filename
    $new_name = uniqid() . "." . $ext;
    $upload_dir = __DIR__ . "/../../../uploads/slider/";

    if(!is_dir($upload_dir)){
        mkdir($upload_dir, 0777, true);
    }

    $upload_path = $upload_dir . $new_name;

    if(move_uploaded_file($image['tmp_name'], $upload_path)){
        // Insert into DB
        $stmt = mysqli_prepare($conn, "INSERT INTO slider_images (image) VALUES (?)");
        mysqli_stmt_bind_param($stmt, "s", $new_name);

        if(mysqli_stmt_execute($stmt)){
            echo json_encode([
                "status" => "success",
                "message" => "Image uploaded successfully",
                "image" => $new_name
            ]);
        } else {
            echo json_encode([
                "status" => "error",
                "message" => mysqli_error($conn)
            ]);
        }

        mysqli_stmt_close($stmt);
    } else {
        echo json_encode([
            "status" => "error",
            "message" => "Failed to upload file"
        ]);
    }

} else {
    echo json_encode([
        "status" => "error",
        "message" => "No file provided"
    ]);
}

mysqli_close($conn);
?>
