<?php
header("Content-Type: application/json");
include __DIR__ . "/../../../includes/config.php";

// POST থেকে ID এবং image file
$id = $_POST['id'] ?? null;

if(!$id || !isset($_FILES['image'])){
    echo json_encode(["status"=>"error", "message"=>"ID and image file are required"]);
    exit;
}

$image = $_FILES['image'];
$upload_dir = __DIR__ . "/../../../uploads/slider/";

// Ensure folder exists
if(!file_exists($upload_dir)){
    mkdir($upload_dir, 0777, true);
}

// Validate image type (jpg, jpeg, png, gif, webp)
$allowed_types = ['image/jpeg', 'image/jpg', 'image/png', 'image/gif', 'image/webp'];
if(!in_array($image['type'], $allowed_types)){
    echo json_encode(["status"=>"error", "message"=>"Invalid image type"]);
    exit;
}

// Generate unique filename
$ext = pathinfo($image['name'], PATHINFO_EXTENSION); // get extension
$imageName = time() . "_" . uniqid() . "." . $ext; 
$targetFile = $upload_dir . $imageName;

// File upload
if(move_uploaded_file($image['tmp_name'], $targetFile)){
    $query = "UPDATE slider_images SET image = ? WHERE id = ?";
    $stmt = mysqli_prepare($conn, $query);
    mysqli_stmt_bind_param($stmt, "si", $imageName, $id);

    if(mysqli_stmt_execute($stmt)){
        echo json_encode([
            "status"=>"success", 
            "message"=>"Slider updated successfully", 
            "image"=>$imageName
        ]);
    } else {
        echo json_encode(["status"=>"error", "message"=>mysqli_error($conn)]);
    }

    mysqli_stmt_close($stmt);
} else {
    echo json_encode(["status"=>"error", "message"=>"Failed to upload image"]);
}

mysqli_close($conn);
?>
