<?php
header("Content-Type: application/json");
include __DIR__ . "/../../../includes/config.php";

// --- Step 1: Read data from JSON body or form-data ---
$input = file_get_contents("php://input");
$data = json_decode($input, true);

if (!$data) {
    // If JSON is empty, try $_POST (form-data)
    $data = $_POST;
}

// --- Step 2: Extract fields safely ---
$quote_id      = $data['id'] ?? null;
$category_id   = $data['category_id'] ?? null;
$category_name = $data['category_name'] ?? null;
$quote_text    = $data['quote_text'] ?? null;

// --- Step 3: Validate required fields ---
if (!$quote_id || !$category_id || !$category_name || !$quote_text) {
    echo json_encode([
        "status" => "error",
        "message" => "All fields are required"
    ]);
    exit;
}

// --- Step 4: Prepare and execute update query ---
$query = "UPDATE quotes 
          SET category_id = ?, category_name = ?, quote_text = ? 
          WHERE id = ?";

$stmt = mysqli_prepare($conn, $query);
mysqli_stmt_bind_param($stmt, "issi", $category_id, $category_name, $quote_text, $quote_id);

if (mysqli_stmt_execute($stmt)) {
    echo json_encode([
        "status" => "success",
        "message" => "Quote updated successfully"
    ]);
} else {
    echo json_encode([
        "status" => "error",
        "message" => mysqli_error($conn)
    ]);
}

// --- Step 5: Close connections ---
mysqli_stmt_close($stmt);
mysqli_close($conn);
?>
