<?php
header("Content-Type: application/json");
include __DIR__ . "/../../../includes/config.php";

// Get POSTed JSON data
$data = json_decode(file_get_contents("php://input"), true);

$id           = $data['id'] ?? null;
$monishi_id   = $data['monishi_id'] ?? null;
$monishi_name = $data['monishi_name'] ?? '';
$quote        = $data['quote'] ?? '';

if (!$id || !$monishi_id || empty($quote) || empty($monishi_name)) {
    echo json_encode(["status" => "error", "message" => "Invalid data"]);
    exit;
}

// Update query including monishi_name
$query = "UPDATE monishider_quotes SET monishi_id = ?, monishi_name = ?, quote = ? WHERE id = ?";
$stmt = mysqli_prepare($conn, $query);
mysqli_stmt_bind_param($stmt, "issi", $monishi_id, $monishi_name, $quote, $id);

if (mysqli_stmt_execute($stmt)) {
    echo json_encode(["status" => "success", "message" => "Quote updated"]);
} else {
    echo json_encode(["status" => "error", "message" => mysqli_error($conn)]);
}

mysqli_stmt_close($stmt);
mysqli_close($conn);
?>
