<?php

header('Content-Type: application/json');
include __DIR__ . "/../../../includes/config.php";

// Check monishi_id exists
if (!isset($_GET['monishi_id']) || empty($_GET['monishi_id'])) {
    echo json_encode([
        'status' => 'error',
        'message' => 'monishi_id is required'
    ]);
    exit;
}

// Correct variable
$monishi_id = intval($_GET['monishi_id']);

// Prepared statement
$stmt = $conn->prepare("
    SELECT 
        id, 
        monishi_id, 
        monishi_name, 
        quote, 
        created_at 
    FROM monishider_quotes 
    WHERE monishi_id = ? 
    ORDER BY id DESC
");

$stmt->bind_param("i", $monishi_id);
$stmt->execute();
$result = $stmt->get_result();

$quotes = [];

while ($row = $result->fetch_assoc()) {
    $quotes[] = $row;
}

echo json_encode([
    'status' => 'success',
    'quotes' => $quotes
]);

$stmt->close();
$conn->close();
?>
