<?php
header("Content-Type: application/json");
include __DIR__ . "/../../../includes/config.php";

$data = json_decode(file_get_contents("php://input"), true);

// Validation
$quote_id = $data['id'] ?? null;

if (!$quote_id) {
    echo json_encode([
        "status" => "error",
        "message" => "Quote ID is required"
    ]);
    exit;
}

$query = "DELETE FROM monishider_quotes WHERE id = ?";
$stmt = mysqli_prepare($conn, $query);
mysqli_stmt_bind_param($stmt, "i", $quote_id);

if (mysqli_stmt_execute($stmt)) {
    echo json_encode([
        "status" => "success",
        "message" => "Quote deleted successfully"
    ]);
} else {
    echo json_encode([
        "status" => "error",
        "message" => mysqli_error($conn)
    ]);
}

mysqli_stmt_close($stmt);
mysqli_close($conn);
?>
