<?php
header('Content-Type: application/json');
include __DIR__ . "/../../../includes/config.php"; // আপনার DB config

// POST method check
if($_SERVER['REQUEST_METHOD'] !== 'POST'){
    echo json_encode(["success"=>false,"error"=>"Only POST requests allowed"]);
    exit;
}

// Validate input
$monishi_id = $_POST['monishi_id'] ?? '';
$name = $_POST['name'] ?? '';

if(empty($monishi_id) || empty($name)){
    echo json_encode(["success"=>false,"error"=>"monishi_id and name are required"]);
    exit;
}

// Handle image upload (optional)
$imagePath = null;
if(isset($_FILES['image'])){
    $targetDir = __DIR__ . "/../../../uploads/slider/";
    if(!file_exists($targetDir)) mkdir($targetDir, 0755, true);

    $fileName = time() . "_" . basename($_FILES['image']['name']);
    $targetFile = $targetDir . $fileName;

    if(move_uploaded_file($_FILES['image']['tmp_name'], $targetFile)){
        $imagePath = "uploads/slider/" . $fileName; // client-accessible path
    }
}

// Update database
if($imagePath){
    $stmt = $conn->prepare("UPDATE monishider SET name=?, image=? WHERE id=?");
    $stmt->bind_param("ssi",$name,$imagePath,$monishi_id);
} else {
    $stmt = $conn->prepare("UPDATE monishider SET name=? WHERE id=?");
    $stmt->bind_param("si",$name,$monishi_id);
}

if($stmt->execute()){
    echo json_encode(["success"=>true,"monishi_id"=>$monishi_id,"name"=>$name,"image"=>$imagePath]);
} else {
    echo json_encode(["success"=>false,"error"=>$stmt->error]);
}

$stmt->close();
$conn->close();
?>
