<?php
header('Content-Type: application/json');
include __DIR__ . "/../../../includes/config.php"; // আপনার DB config path

// POST method check
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    echo json_encode(["success"=>false,"error"=>"Only POST requests allowed"]);
    exit;
}

// Validate name
$name = $_POST['name'] ?? '';
if(empty($name)){
    echo json_encode(["success"=>false,"error"=>"Name is required"]);
    exit;
}

// Handle image upload
$imagePath = null;
if(isset($_FILES['image'])){
    $targetDir = __DIR__ . "/../../../uploads/monishi/";
    if(!file_exists($targetDir)) mkdir($targetDir, 0755, true);

    $fileName = time() . "_" . basename($_FILES['image']['name']);
    $targetFile = $targetDir . $fileName;

    if(move_uploaded_file($_FILES['image']['tmp_name'], $targetFile)){
        $imagePath = "uploads/monishi/" . $fileName; // client-accessible path
    }
}

// Insert into database
$stmt = $conn->prepare("INSERT INTO monishider (name, image) VALUES (?, ?)");
$stmt->bind_param("ss", $name, $imagePath);

if($stmt->execute()){
    echo json_encode([
        "success" => true,
        "monishi_id" => $stmt->insert_id,
        "name" => $name,
        "image" => $imagePath
    ]);
} else {
    echo json_encode([
        "success" => false,
        "error" => $stmt->error
    ]);
}

$stmt->close();
$conn->close();
?>
