<?php
header("Content-Type: application/json; charset=UTF-8");
include __DIR__ . "/../../../includes/config.php";

// Allow POST only
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    echo json_encode([
        "status" => "error",
        "message" => "Only POST method is allowed!"
    ]);
    exit;
}

// Validate required fields
if (!isset($_POST['id']) || empty(trim($_POST['id']))) {
    echo json_encode([
        "status" => "error",
        "message" => "Category ID is required!"
    ]);
    exit;
}

if (!isset($_POST['name']) || empty(trim($_POST['name']))) {
    echo json_encode([
        "status" => "error",
        "message" => "Category name is required!"
    ]);
    exit;
}

$id = intval($_POST['id']);
$name = mysqli_real_escape_string($conn, $_POST['name']);
$old_image = isset($_POST['old_image']) ? $_POST['old_image'] : null;
$image = $old_image; // by default keep old image

// Handle new image upload
if (isset($_FILES['image']) && $_FILES['image']['name'] !== '') {

     $uploadDir = __DIR__ . "/../../../uploads/category/";

    if (!is_dir($uploadDir)) {
        mkdir($uploadDir, 0777, true);
    }

    $file_ext = strtolower(pathinfo($_FILES['image']['name'], PATHINFO_EXTENSION));
    $allowed_ext = ['jpg','jpeg','png'];

    if (!in_array($file_ext, $allowed_ext)) {
        echo json_encode([
            "status" => "error",
            "message" => "Invalid image format! Allowed: jpg, jpeg, png"
        ]);
        exit;
    }

    $image = time() . '_' . rand(1000,9999) . '.' . $file_ext;
    $target_path = $uploadDir . $image;

    if (!move_uploaded_file($_FILES['image']['tmp_name'], $target_path)) {
        echo json_encode([
            "status" => "error",
            "message" => "Image upload failed!"
        ]);
        exit;
    }

    // Delete old image if exists
    if ($old_image && file_exists($uploadDir . $old_image)) {
        unlink($uploadDir . $old_image);
    }
}

// Update in database
$query = "UPDATE category SET name='$name', image=" . ($image ? "'$image'" : "NULL") . " WHERE id=$id";

if (mysqli_query($conn, $query)) {
    echo json_encode([
        "status" => "success",
        "message" => "Category updated successfully!",
        "data" => [
            "id" => $id,
            "name" => $name,
            "image" => $image ? $image : null
        ]
    ]);
} else {
    echo json_encode([
        "status" => "error",
        "message" => "Database update failed: " . mysqli_error($conn)
    ]);
}
?>
