<?php
header("Content-Type: application/json; charset=UTF-8");
include __DIR__ . "/../../../includes/config.php";

// POST only
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    echo json_encode(["status" => "error", "message" => "Only POST method is allowed!"]);
    exit;
}

// Validate
if (!isset($_POST['id']) || empty($_POST['id'])) {
    echo json_encode(["status" => "error", "message" => "Category ID is required!"]);
    exit;
}

$id = intval($_POST['id']);

// Fetch category
$data = mysqli_query($conn, "SELECT * FROM category WHERE id='$id'");
if (mysqli_num_rows($data) == 0) {
    echo json_encode(["status" => "error", "message" => "Category not found!"]);
    exit;
}

$row = mysqli_fetch_assoc($data);

// Delete image
if ($row['image']) {
    $file = "../../uploads/category/" . $row['image'];
    if (file_exists($file)) unlink($file);
}

// Delete category
if (mysqli_query($conn, "DELETE FROM category WHERE id='$id'")) {
    echo json_encode([
        "status" => "success",
        "message" => "Category deleted successfully!"
    ]);
} else {
    echo json_encode([
        "status" => "error",
        "message" => "Delete failed!"
    ]);
}
