<?php
header("Content-Type: application/json; charset=UTF-8");
include __DIR__ . "/../../../includes/config.php";

// Allow POST only
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    echo json_encode([
        "status" => "error",
        "message" => "Only POST method is allowed!"
    ]);
    exit;
}

// Validate category name
if (!isset($_POST['name']) || empty(trim($_POST['name']))) {
    echo json_encode([
        "status" => "error",
        "message" => "Category name is required!"
    ]);
    exit;
}

$name = mysqli_real_escape_string($conn, $_POST['name']);
$image = null;

// Handle image upload
if (isset($_FILES['image']) && $_FILES['image']['name'] !== '') {

   $uploadDir = __DIR__ . "/../../../uploads/category/";


    // Create folder if it doesn't exist
    if (!is_dir($uploadDir)) {
        mkdir($uploadDir, 0777, true);
    }

    // Generate unique image name
    $file_ext = strtolower(pathinfo($_FILES['image']['name'], PATHINFO_EXTENSION));
    $allowed_ext = ['jpg','jpeg','png'];

    if (!in_array($file_ext, $allowed_ext)) {
        echo json_encode([
            "status" => "error",
            "message" => "Invalid image format! Allowed: jpg, jpeg, png"
        ]);
        exit;
    }

    $image = time() . '_' . rand(1000,9999) . '.' . $file_ext;
    $target_path = $uploadDir . $image;

    if (!move_uploaded_file($_FILES['image']['tmp_name'], $target_path)) {
        echo json_encode([
            "status" => "error",
            "message" => "Image upload failed!"
        ]);
        exit;
    }
}

// Insert category into database
$query = "INSERT INTO category (name, image) VALUES('$name', ".($image ? "'$image'" : "NULL").")";

if (mysqli_query($conn, $query)) {
    echo json_encode([
        "status" => "success",
        "message" => "Category added successfully!",
        "data" => [
            "name" => $name,
            "image" => $image ? $image : null
        ]
    ]);
} else {
    echo json_encode([
        "status" => "error",
        "message" => "Database insert failed: " . mysqli_error($conn)
    ]);
}
?>
